'
' All objects that implement operations for StreamingSensor objects must
' implement this interface.
'
Public Interface StreamingSensorImpl
    Inherits SimpleSensorImpl
    '
    ' Streaming sensors produce a stream of measurement values.  The
    ' stream of values is produced with a frequency no greater than
    ' the given number of times per minute.
    '
    WriteOnly Property SamplingFrequency() As Integer
    '
    ' This property is set by an object than represents the
    ' streaming sensor abstraction so that this object can perform a
    ' call-back to that object to deliver measurement values to it.
    '   
    WriteOnly Property StreamingSensorListener() As StreamingSensorListener
End Interface 'StreamingSensorImpl